#include <stdio.h>
#include <cdefBF535.h>
#include <signal.h>

void spi_isr(int i);


short int SPI_RD_VALUE;
short int SPI_RD_VALUE_TEMP;

void main(void)
{
	
	//Clear the SPI0 registers
	*pSPI0_FLG = 0;
	*pSPI0_BAUD = 0;
	*pSPI0_CTL = 0;
	//set up interrupt mask for SPI0 interrupt.spi_isr is the interrupt handler
	interrupt(SIGIVG9, spi_isr);
	
	*pSIC_IMASK = SIC_MASK8;//SIC_MASK_ALL;
	
	*pSPI0_FLG = FLS1;//PF2 becomes CS# for AD7276
	*pSPI0_CTL = SIZE | CPOL | MSTR | SPE | SZ;
	//For TIMOD1 condition, modified the defBF535.h file
	*pSPI0_BAUD = 6;//This value will decide the serial bit clock for AD7276 

	//Dummy read has be done in order to initiate the read hence SCK0 and PF2
	SPI_RD_VALUE = *pSPI0_RDBR;
	while(1)
	{
		//wait for SPI receive interrupt and read the data in the receive interrupt
	}
	
	
	
}

void spi_isr(int i)
{
	SPI_RD_VALUE_TEMP = *pSPI0_RDBR;//read receive buffer 
	SPI_RD_VALUE = SPI_RD_VALUE_TEMP >> 2;//First two bits are zero hence right shift to get 12-bit ADC data
}
